unit mVimmGrid;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVimmBase, Vcl.Grids, Vcl.StdCtrls,
  Vcl.ExtCtrls, rVimm, Vcl.ComCtrls, ORFn, Vcl.Menus, Vcl.ImgList, Vcl.Buttons;

type
  TfraGrid = class(TfraParent)
    lstView: TListView;
    popMenu: TPopupMenu;
    addImm: TMenuItem;
    editImm: TMenuItem;
    delImm: TMenuItem;
    viewImm: TMenuItem;
    lblAdd: TLabel;
    procedure popMenuPopup(Sender: TObject);
    procedure addImmClick(Sender: TObject);
    procedure editImmClick(Sender: TObject);
    procedure viewImmClick(Sender: TObject);
    procedure delImmClick(Sender: TObject);
  private
    { Private declarations }
    procedure startUpdates(immunization: string = ''; details: boolean = false);
    function setImmunizationStr: string;
  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
//    destructor Destroy; override;
    procedure updateGrid(idx: integer);
    procedure addListToGrid(inputList: TStringList; documentType: string);
    procedure addToGrid(row, idx: integer; vimmData: TVimmResult);
    function getRowIndex(idx: integer; vimmData: TVimmResult): integer;
    procedure collapse;
    procedure expand;
    function validateGridResults: boolean;
  end;

var
  fraGrid: TfraGrid;

implementation

uses
  mVimmSelect;

{$R *.dfm}

{ TfraGrid }

procedure TfraGrid.addImmClick(Sender: TObject);
begin
  startUpdates('');
end;

//add initial values to the grid values have to be pass in from calling application
procedure TfraGrid.addListToGrid(inputList: TStringList; documentType: string);
var
i, idx: integer;
tmp: string;
begin
  for i := 0 to inputList.Count - 1 do
    begin
      tmp := inputList.Strings[i];
      if Piece(tmp, U, 3) = '-1' then
        begin
          if inputLIst.Count = 1 then idx := setInitialVimmResult(tmp, documentType)
          else idx := setInitialVimmResult(tmp, '');
          if idx = -1 then continue;
        end
      else idx := StrToInt(Piece(tmp, U, 3));
      updateGrid(idx);
    end;
  if inputList.count = 1 then
    begin
      self.lstView.ItemIndex := 0;
      editImmClick(self);
    end;
end;

//add an individual item to the grid. Both from initial list and from editor and the add button
procedure TfraGrid.addToGrid(row, idx: integer; vimmData: TVimmResult);
var
 lstItem: TListItem;
 strs: TStrings;
 item: TStringList;
begin
  item := TStringList.create;
  try
  lstView.Items.BeginUpdate;
  strs := TStringList.Create;
  strs.Add(vimmData.name);
  strs.Add(vimmData.documType);
  if vimmData.isComplete then
    begin
      strs.Add('Complete');
    end
  else strs.Add('Incomplete');
  if row > -1 then
    begin
      lstView.Items.Item[row].Caption := IntToStr(idx);
      lstView.Items.Item[row].SubItems := strs;
    end
    else
      begin
        lstItem := lstView.Items.Add;
        lstItem.Caption := IntToStr(idx);
        lstItem.SubItems := strs;
      end;
  lstView.Items.EndUpdate;
  finally
    item.free;
  end;

end;

procedure TfraGrid.collapse;
begin
  if not fcollapsed then spbtnExpandCollapseClick(self);
end;

constructor TfraGrid.Create(aOwner: TComponent);
begin
  inherited;
  style := ssAbsolute;
  minValue := pnlWorkspace.Top + pnlWorkspace.Height;
end;

procedure TfraGrid.delImmClick(Sender: TObject);
var
immunization: string;
begin
//  inherited;
  immunization := setImmunizationStr;
  if immunization = '' then exit;
  ShowMessage('You are about to delete this immunization. Are you sure?');
  if removeVimmResult(immunization) = false then
    begin
      ShowMessage('Problem removing record.');
      Exit;
    end;
    lstView.DeleteSelected;
end;

procedure TfraGrid.editImmClick(Sender: TObject);
var
immunization: string;
begin
  immunization := setImmunizationStr;
  if immunization = '' then exit;
  startUpdates(immunization);
end;

procedure TfraGrid.expand;
begin
  if fCollapsed then spbtnExpandCollapseClick(self);
end;

//find row that matches the vimm result data
function TfraGrid.getRowIndex(idx: integer; vimmData: TVimmResult):integer;
var
 lstItem: TListItem;
 i: integer;
begin
  result := -1;
  for i := 0 to lstView.Items.Count - 1 do
    begin
      lstItem := lstView.Items.Item[i];
      if lstItem.Caption = IntToStr(idx) then
        begin
          result := i;
          exit;
        end;
    end;
end;


procedure TfraGrid.popMenuPopup(Sender: TObject);
begin
    if lstView.ItemIndex = -1 then
      begin
        popMenu.Items[1].Enabled := false;
        popMenu.Items[2].Enabled := false;
        popMenu.Items[3].Enabled := false;
      end
    else begin
      popMenu.Items[1].Enabled := true;
      popMenu.Items[1].Enabled := true;
      popMenu.Items[2].Enabled := true;
      popMenu.Items[3].Enabled := true;
    end;

end;

//build immunization string
//pick list id^name^documentation Type
//or
//result id^name^documentation type
function TfraGrid.setImmunizationStr: string;
var
lstItem: TListItem;
idx: integer;
documType, name, vid: string;
begin
  result := '';
  idx := lstView.ItemIndex;
  if idx = -1 then
    begin
      ShowMessage('No row selected');
      exit;
    end;
  lstItem := lstView.Items.Item[idx];
  vid := lstItem.Caption;
  name := lstItem.SubItems[0];
  documType := lstItem.SubItems[1];
  result := vid + U + name + U + documType;
end;

//calls to the immunization frame to start the update process
//both new and edit records
procedure TfraGrid.startUpdates(immunization: string = ''; details: boolean = false);
var
grid: TGridPanel;
aControl: TControl;
begin
  grid := TGridPanel(self.Parent);
  aControl := grid.ControlCollection.Controls[0, 2];
  TfraImm(aControl).startEdits(immunization, details);
end;

procedure TfraGrid.updateGrid(idx: integer);
var
vimmData: TVimmResult;
i: integer;
begin
  vimmData := getVimmResult(idx);
  i := getRowIndex(idx, vimmData);
  addToGrid(i, idx, vimmData);
end;

//check all rows for a status of complete.
//the only way the form can save data if grid is showing
function TfraGrid.validateGridResults: boolean;
var
row: integer;
lstItem: TListItem;
begin
  result := true;
  for row := 0 to self.lstView.Items.Count -1 do
    begin
      lstItem := lstView.Items.Item[row];
      if lstItem.SubItems[2] <> 'Complete' then
        begin
          result := false;
          exit;
        end;
    end;
end;

procedure TfraGrid.viewImmClick(Sender: TObject);
var
immunization: string;
begin
  immunization := setImmunizationStr;
  if immunization = '' then exit;
  startUpdates(immunization, true);
end;

end.
